#!/bin/bash

# Runs the Validate External Links script
# Arguments: --help, --links URL, --exceptions URL, --output DIR, --record-ok-links,
# --suggest-snapshots, --take-screenshots FILE, --start-url NUM, --end-url NUM, --upload FILE
# Recommended rule:
# ----------------------------------------------------------------------------------------------

# Set variables for any arguments we might use below
VALEXTLINKS="/path/to/Validate External Links/validate_external_links.sh"
LINKS_LOCAL="file:///path/to/Validate External Links/Sample files/extlinks.csv"
LINKS_ONLINE="http://wiki.oni2.net/w/extlinks.csv"
EXCEPT_LOCAL="file:///path/to/Validate External Links/exceptions.txt"
EXCEPT_ONLINE="http://iritscen.oni2.net/val/exceptions.txt"
REPORT_DIR="/path/to/ValExtLinks reports"
UPLOAD_INFO="/path/to/Validate External Links/sftp_login.txt"
CHROME="/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary"


# Run for limited number of URLs, and record OK codes
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots --end-url 70

# Run with local extlinks and exceptions, start/end URLs, and record OK codes
#bash "$VALEXTLINKS" --links "$LINKS_LOCAL" --exceptions "$EXCEPT_LOCAL" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots --start-url 3394 --end-url 3417

# Run with unfinished screenshot feature
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --take-screenshots "$CHROME"

# Normal run with upload
bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --suggest-snapshots --upload "$UPLOAD_INFO"